/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

public class ApplesoftToken {
    private int lineNumber;
    private byte tokenValue;
    private String tokenString;
    private String stringValue;

    public ApplesoftToken(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public ApplesoftToken(byte tokenValue, String tokenString) {
        this.tokenValue = tokenValue;
        this.tokenString = tokenString;
    }

    public ApplesoftToken(String stringValue) {
        this.stringValue = stringValue;
    }

    public boolean isCommandSeparator() {
        return ":".equals(this.stringValue);
    }

    public boolean isLineNumber() {
        return !this.isToken() && !this.isString();
    }

    public boolean isEndOfCommand() {
        return this.isLineNumber() || this.isCommandSeparator();
    }

    public boolean isToken() {
        return this.tokenString != null;
    }

    public boolean isString() {
        return this.stringValue != null;
    }

    public boolean isExpressionSeparator() {
        return this.isCommandSeparator() || ",".equals(this.stringValue) || ";".equals(this.stringValue);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public byte getTokenValue() {
        return this.tokenValue;
    }

    public String toString() {
        if (this.isLineNumber()) {
            return Integer.toString(this.getLineNumber());
        }
        if (this.isToken()) {
            return this.getTokenString() + " " + Integer.toHexString(this.getTokenValue());
        }
        return this.getStringValue();
    }
}

